package gov.va.vinci.dart.db;

import java.util.Date;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.RequestLocationDocumentSummary;
import gov.va.vinci.dart.biz.RequestParticipantDocumentSummary;
import gov.va.vinci.dart.biz.RequestSummary;

public interface RequestDAO {

	Request findById(final int requestId) throws ObjectNotFoundException;
	Request findByTrackingNumber(final String trackingNumberStr) throws ObjectNotFoundException;
	void save(Request request);
	int countRequestsInMonth();
	int countRequestAmendments(int requestId);
	List<RequestSummary> listByTrackingNumber(final String trackingNumber);
	List<RequestLocationDocumentSummary> listRequestLocationDocumentSummaryByReviewer(final int requestId, final String reviewer);
	List<RequestParticipantDocumentSummary> listRequestParticipantDocumentSummaryByReviewer(final int requestId, final String reviewer);
	List<RequestSummary> listAllRequestSummary();
	List<RequestSummary> listAllRequestSummaryByParticipant(String participantId);
	@Deprecated
	List<RequestSummary> listAllRequestSummaryWithoutContactName();
	List<RequestSummary> listAllButInitiated();
	List<RequestSummary> listAllButInitiatedWithoutContactName();
	@Deprecated
	List<RequestSummary> listAllUserReviewable(final int userId);
	List<RequestSummary> listAllGroupReviewable_old(final int groupId);
	List<RequestSummary> listAllGroupReviewable(final String groupName);
	List<Request> listAllRequestByHeadId(final int headId);  /*new*/
	List<Request> listAllPreviousRequests(final int headId, final Date createdOn);
	List<Request> listAllPreviousRequests(final int headId, final String trackingNumberStr);
	List<Integer> listAllPreviousRequestIds(final int headId, final String trackingNumberStr);
	
	/**
	 * Find expected IRB submission by date.
	 *
	 * @param date the date
	 * @return the list
	 */
	List<Request> findExpectedIRBSubmissionByDate(Date date);
}
